/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build.properties;

import com.aptana.css.core.internal.build.properties.ICSSValueValidator;
import com.aptana.css.core.internal.build.properties.PlugableCSSProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class MozOpacityCSSProperty
extends PlugableCSSProperty {
    private static final String PROPERTY_NAME = "-moz-opacity";
    private static final OpacityValidator VALIDATOR = new OpacityValidator();

    public MozOpacityCSSProperty() {
        super(PROPERTY_NAME);
    }

    public MozOpacityCSSProperty(ApplContext context, CssExpression expression, boolean check) throws InvalidParamException {
        super(PROPERTY_NAME, new Class[]{CssNumber.class}, null, new ICSSValueValidator[]{VALIDATOR}, context, expression, check);
    }

    public MozOpacityCSSProperty(ApplContext context, CssExpression expression) throws InvalidParamException {
        this(context, expression, false);
    }

    private static class OpacityValidator
    implements ICSSValueValidator {
        private OpacityValidator() {
        }

        public boolean canValidate(CssValue value) {
            return value instanceof CssNumber;
        }

        public boolean isValid(CssValue value) {
            if (!this.canValidate(value)) {
                throw new IllegalArgumentException("Value " + value + " can not be validated");
            }
            float fValue = ((CssNumber)value).getValue();
            return fValue >= 0.0f && fValue <= 1.0f;
        }
    }
}

